$(function () {

    // Initiate the chart
    $('#the-map-container').highcharts('Map', {
        series: [{
            animation: {
                duration: 1000
            },
            name: "Collected Revenue",
            colorByPoint: false,
            color: '#3b3b3b', // blue
            borderWidth: 1,
            borderColor: '#212327',
			borderColor: '#212327',
             dataLabels: {
                enabled: true,
                backgroundColor: 'rgba(0,0,0,0.3)',
                borderRadius: 0,
                padding: 4,
//                color: '#a5a8ad',
                format: '{point.name}',
				 shadow: "none",
               
                style: {
                    textTransform: 'uppercase',
                    fontWeight: '500',
					fontFamily: '"Muli", sans-serif',
  					fontSize: '1rem'
                }
            },
			symbol:'circle',
			 marker: {
            symbol: 'square'
        },
    

            "type": "map",
            "joinBy": "id",
            "mapData": [{
                    "id": "id0",
                    "name": "Langata",
                    "path": "M32.322848752353174,-657.9230784350199L26.066815397640475,-645.4110273304013L10.426730060257876,-648.5390498595601L0.0000039012016827694735,-614.1308410508292L19.810782042927773,-607.8748350045283L10.426730060257876,-599.533441593438L22.938800670884966,-587.0213904888194L33.365522928739466,-597.4480932406656L36.49353765549497,-575.5519745485702L46.92026381455116,-579.7226712541153L47.96293408973576,-559.9119009147926L58.38965634759027,-541.1438047518562L64.64569360350467,-534.8877596935384L69.85905317195125,-535.9304338699247L83.41379405776294,-542.1864789282425L96.96853377321412,-526.546366282448L118.86465246530943,-512.9916410014431L149.10214974392866,-484.83947725102996L176.21163151555209,-468.1567294408662L184.55300932183567,-477.54079702834287L200.19309465921827,-460.8580102061621L218.96119862455805,-460.8580102061621L225.21722807806907NaNL540.2390367848733NaNL595.500666702103NaNL602.799374233202NaNC713.3226418700648NaNNaNNaNNaNNaNL772.7549567892346NaNC772.7549567892346NaNNaNNaNNaNNaNL811.3338466987038NaNC811.3338466987038NaNNaNNaNNaNNaNL912.4730467480899NaNC912.4730467480899NaNNaNNaNNaNNaNL966.6920258961435NaNL966.6920258961435NaNL980.2467511771484NaNC984.4174478826935NaNNaNNaNNaNNaNL914.5583951008624NaNC914.5583951008624NaNNaNNaNNaNNaNL820.7178752741634NaNC820.7178752741634NaNNaNNaNNaNNaNL730.0053974826317NaNC730.0053974826317NaNNaNNaNNaNNaNL625.73815929928NaNL601.7567039580173NaNL588.2019552698023NaNC588.2019552698023NaNNaNNaNNaNNaNL521.4709328195335NaNC521.4709328195335NaNNaNNaNNaNNaNL455.7825728420459NaNC457.8679211948185NaNNaNNaNNaNNaNL443.27050730298106NaNC443.27050730298106NaNNaNNaNNaNNaNL352.5580166374839NaN"
                },
                {
                    "id": "id1",
                    "name": "Dagoreti South",
                    "path": "M220.00386889974266,-660.2691050848932L207.752468783813,-667.8284636046812L206.9704651021241,-670.95648613384C206.9704651021241,-670.95648613384,190.80904267654836,-673.3025127837135,187.15969086159967,-677.2125311921579C183.51033514544937,-681.1225496006023,178.03630547242554,-684.2505721297612,178.03630547242554,-684.2505721297612L180.64298701218956,-686.5965597676177L172.04094261241025,-694.4166355965233L165.52423876300014,-697.8052974107661L165.00290167480702,-709.2747133510153L162.65689062974033,-711.0993834066871C162.65689062974033,-711.0993834066871,163.96023139962236,-707.7106825804275,158.7468683200943,-710.8387831336202C153.5335052405662,-713.9668056627792,149.3628163374244,-717.094828191938,149.3628163374244,-717.094828191938C149.3628163374244,-717.094828191938,144.9314608407869,-723.6115125353397,141.0214397015013,-725.4362216030283C137.11141856221576,-727.2608916587002,130.0733799653335,-723.090194953155,126.68469474388056,-728.3035268230694C123.29600952242764,-733.5168977050009,124.07801437447704,-741.5976128189905,124.07801437447704,-741.5976128189905L119.12532022916568,-746.0289878216365L114.95463132602389,-746.5503054038213C114.95463132602389,-746.5503054038213,93.319180787905,-750.1996845271818,91.2338363363341,-751.5029979886518C89.1484918847632,-752.806350462139,85.75980666331027,-743.9436394688639,85.75980666331027,-743.1616435895784C85.75980666331027,-742.379608698276,80.02510883631004,-744.2043177659647,80.02510883631004,-744.2043177659647L76.89709137871336,-747.0716619980228L71.42306170568953,-747.5929795802076C71.42306170568953,-747.5929795802076,71.1623951121938,-742.379608698276,70.90172578785689,-741.0762952368059C70.64105919436116,-739.7729427633187,66.20970096688245,-738.4695902898317,66.20970096688245,-738.4695902898317L65.42769728519357,-736.9055985312607L70.64105802400066,-736.3842419370591L70.11972210616801,-732.7349018257155L75.59375060883134,-731.95290594643L76.11508769702449,-728.3035268230694L72.98707023942781,-728.3035268230694L71.16239355171315,-724.9148650088267L67.25237241242758,-729.3462400114728L64.64569360350472,-724.654186711726L61.51767497554753,-723.090194953155L60.2143342056655,-719.962172423996L64.3850231088073,-712.663453189292L56.043645302523714,-715.0094798391655L55.78296700542291,-705.8860905487895L57.8683114569938,-704.3220987902185L58.9109817321784,-696.2413836762289C58.9109817321784,-696.2413836762289,54.218955740843455,-694.9380312027419,52.6549483774657,-692.8526828499693C51.090941014087946,-690.7673344971967,51.87294469577683,-685.5539636152652,51.87294469577683,-685.5539636152652L46.65958161624873,-676.951930919091L45.87757793455985,-672.5205559164449L43.53156688949323,-668.3498982229166L32.322837048748156,-657.9231564590538L46.920252110946144,-655.837808106281L54.21895574084344,-664.1792015173714L54.21895574084344,-664.1792015173714L70.32910506269327,-662.1097310554878L78.30952964404966,-659.3792799908238L83.75604921309764,-655.6878069011999L87.32619727080207,-652.9735458235601L90.92842256930388,-650.1094005768899L93.38717834328719,-648.1002036811573L99.05386652117998,-643.3257570016624L100.7696930496277,-653.9433455523283L101.7090287235104,-659.2855341141501L102.61813035735942,-663.749718223031L103.0470214102709,-665.0813934208065L107.14657693309798,-660.2921221748796L123.24477308999768,-654.835199271278L137.63274277644337,-651.667111400736L145.97411941236646,-666.2645498701442L156.1006090891587,-664.7758513042406L158.5401670496126,-664.1925046151433L162.69325763191898,-662.6970569703117L164.8933013144546,-660.7812548431003L163.72001100419774,-657.9407508786874C163.72001100419774,-657.9407508786874,160.9288065255745,-655.5713950426923,159.15960765677005,-655.0786342568974C157.39040488676392,-654.5859124831197,152.23015666828084,-655.8378081062812,152.23015666828084,-655.8378081062812L150.14480831550827,-638.112386119731L180.38230871508884,-645.4111053544351"
                },
                {
                    "id": "id2",
                    "name": "Kibra",
                    "path": "M220.00386889974266,-660.2691050848932C220.00386889974266,-660.2691050848932,233.55860588435266,-660.2691050848932,234.861942753033,-658.9657526114062C236.165283522915,-657.662439149936,236.4259540176124,-657.9230784350199,236.4259540176124,-657.9230784350199C236.4259540176124,-657.9230784350199,295.33693965099246,-659.4871092056078,298.7256326748488,-659.4871092056078C302.1143100938983,-659.4871092056078,312.2803657582571,-658.9657526114062,312.2803657582571,-660.2691050848932C312.2803657582571,-661.5724575583804,309.67368811969476,-664.1791234933377,309.67368811969476,-664.1791234933377C309.67368811969476,-664.1791234933377,327.3991140074466,-662.093775140565,327.9204549968414,-662.8757710198505C328.44178428263115,-663.6578059111529,328.963125272026,-667.3071460224966,330.52713263540375,-667.5678243195973C332.09114389998314,-667.8284245926643,339.1291809363848,-666.0037935490095,339.6505102221745,-666.0037935490095C340.17185121156933,-666.0037935490095,340.43252170626675,-670.4351685516555,343.0391993448291,-670.4351685516555C345.64588088459317,-670.4351685516555,353.9872586908768,-671.7384820131257,353.9872586908768,-671.7384820131257C353.9872586908768,-671.7384820131257,359.4612883639006,-667.5678243195974,362.3286364971604,-662.8757710198506C365.1959846304201,-658.1837567321207,368.8453442477722,-647.7570149682577,368.8453442477722,-647.7570149682577L378.42205317483035,-626.6453499125143L361.12613398862914,-640.560624253951C361.12613398862914,-640.560624253951,357.0517462492696,-647.6960781978191,350.32675334028886,-646.9081134799438C343.60176823371154,-646.1201877740856,335.68178262945787,-643.7458774119407,335.68178262945787,-643.7458774119407L323.2284251043047,-638.1123080956972L320.1004064763475,-624.5575828146923L314.88704729802106,-619.3442119327608L300.2896400382265,-637.069633919311L292.99093250712747,-625.6002569910786L313.84437702283645,-614.1308410508293L296.11895113508467,-614.1308410508293L282.56420244686956,-624.5575828146923L272.4779536655367,-618.1686628267239C272.4779536655367,-618.1686628267239,266.0692155729698,-615.1811225705162,262.99142101560335,-615.9943280633428C259.91361865583355,-616.8075725681862,250.07601296437974,-622.2400739491919,250.07601296437974,-622.2400739491919L243.4661289125414,-626.7511114904012L232.51593560916788,-634.9842855665383L215.83317999660068,-629.7709536966238C215.83317999660068,-629.7709536966238,203.6215877427425,-634.149350380284,201.4733910307018,-637.2763585970027C199.32519431866115,-640.4033668137217,195.9879971571474,-642.6778844365693,195.9879971571474,-642.6778844365693C195.9879971571474,-642.6778844365693,180.38232041869367,-645.4110273304013,180.38232041869367,-645.4110273304013"
                },
                {
                    "id": "id3",
                    "name": "Dagoreti North",
                    "path": "M165.00290167480702,-709.2747133510153C165.00290167480702,-709.2747133510153,173.34428338229228,-706.1466908218564,176.4722981090478,-706.4073691189573C179.60031673700496,-706.6679693920242,188.72369822497748,-715.0094018151316,188.72369822497748,-715.0094018151316C188.72369822497748,-715.0094018151316,194.45839449149705,-714.4880452209298,196.02240575607647,-713.4453710445435C197.5864131194542,-712.4027358801743,206.70979460742672,-713.4453710445435,207.49180219031726,-715.5307193973161C208.27380587200614,-717.6160677500889,211.66249109345907,-719.7014161028613,214.52983922671882,-720.222772697063C217.39718735997863,-720.7440902792476,218.96119862455805,-724.3934303905912,217.65785785467605,-727.0001353375654C216.35451708479403,-729.6068012725228,211.9231576869548,-733.5168196809672,208.7951390589976,-733.2561803958832C205.6671243322421,-732.9955801228164,206.70979460742672,-737.1661988043277,208.0131353773087,-737.9481946836131C209.31648004839246,-738.7301905628985,221.04653917492726,-739.5121864421841,224.4352282975819,-739.2515471571003C227.82390571663143,-738.9909468840333,237.4686320952005,-744.2042397419309,238.5113023703851,-744.9862356212165C239.55397264556967,-745.768231500502,248.93802072703792,-747.3322232590729,251.0233690798105,-746.0289097976028C253.10870963017967,-744.7255573241157,254.67272089475915,-749.1569323267616,266.1421173289999,-748.8962540296608C277.6115137632407,-748.6356537565938,293.251603001825,-744.2042397419309,293.251603001825,-744.2042397419309L295.0762730574968,-741.5975347949567L307.8490102616196,-743.6828831477294L308.37034734981273,-739.5121864421842C308.37034734981273,-739.5121864421842,319.3184066958604,-734.2988155602526,320.88241405923816,-731.9528279223962C322.44642532381755,-729.6068012725228,322.96775460960737,-723.0901169291212,322.96775460960737,-723.0901169291212L334.43715104384813,-716.3127542886186C334.43715104384813,-716.3127542886186,340.95386269566166,-691.5492913644654,344.0818696200138,-688.6819081203903C347.20988824797104,-685.8145638883323,350.76250196454777,-685.2205279065971,350.85924006291964,-678.2552053685442C350.95595085287965,-671.2898828304914,353.98725869087684,-671.7384820131257,353.98725869087684,-671.7384820131257L343.850598581272,-670.4636473240115C343.850598581272,-670.4636473240115,340.32441160496097,-666.1241456212267,339.780900086347,-666.0965251132432C339.23739637013637,-666.0692167013948,330.528361513937,-668.7617090735896,329.6387041715403,-666.9747636382855C328.7490585327487,-665.1878572149982,327.4410519256423,-662.7359909632041,327.4410519256423,-662.7359909632041L309.6736881196948,-664.1791234933378L309.6736881196948,-664.1791234933378L312.25273744787006,-660.1553850555536L295.34399302365284,-659.4258213270168L236.42595401761253,-657.92307843502L236.42595401761253,-657.92307843502C236.42595401761253,-657.92307843502,236.42595401761253,-657.92307843502,236.42595401761253,-657.92307843502L236.42595401761253,-657.92307843502L230.6539115472895,-659.8628729526409L220.0038688997427,-660.2691050848933L207.75246878381304,-667.8284636046814L206.97046510212417,-670.9564861338403L191.81364502561647,-674.5783227732509L183.34091375834234,-680.644379309138L178.0363054724256,-684.2505721297613L180.64298701218962,-686.5965597676177L172.0409426124103,-694.4166355965233L165.5242387630002,-697.8052974107662"
                },
                {
                    "id": "id4",
                    "name": "Starehe",
                    "path": "M334.43715104384813,-716.3127542886186L341.4751919814514,-725.1754652818936L364.1533182564373,-725.1754652818936L365.1959846304202,-728.5641270961364C365.1959846304202,-728.5641270961364,376.66538496586264,-727.782131216851,381.87874414418906,-729.8674795696235C387.09211112491886,-731.9528279223961,393.08747008373246,-735.8628463308405,393.08747008373246,-735.8628463308405C393.08747008373246,-735.8628463308405,392.3054703032453,-738.2088339686969,393.3481483808333,-739.5121864421841C394.3908186560179,-740.8155389156711,399.34351514205025,-740.8155389156711,401.1681969013272,-739.772786715251C402.99286695699897,-738.7301125388647,407.94556344303135,-737.6874383624785,407.94556344303135,-737.6874383624785C407.94556344303135,-737.6874383624785,407.94556344303135,-723.350717202188,409.2489042129133,-721.2653688494154C410.55224498279534,-719.1800204966428,413.68026361075255,-698.3265759809337,408.72756322351853,-695.198553451775C403.7748745398895,-692.070530922616,398.82217805385716,-692.8525268019015,397.51883728397513,-692.3312092197168C396.2154965140931,-691.8098526255152,395.9548260193957,-685.2931682821136,395.9548260193957,-685.2931682821136C395.9548260193957,-685.2931682821136,392.3054781056488,-683.207819929341,394.390818656018,-682.9471416322401C396.4761670087906,-682.6865413591731,401.4288556924195,-681.6437891587531,402.21086717651184,-680.3404756972828C402.992866956999,-679.0371232237958,402.7321964623016,-673.3024347596796,401.950188879411,-673.3024347596796C401.1681890989238,-673.3024347596796,397.51882948157174,-672.5203998683771,396.73682970108456,-672.7810781654779C395.95481821699235,-673.0416784385449,406.90287756303997,-657.4016828288012,406.90287756303997,-657.4016828288012L408.46688882761936,-652.7096685410714C408.46688882761936,-652.7096685410714,419.67561476716276,-653.4916644203569,420.45762625125496,-653.230986123256C421.23962603174215,-652.970385850189,422.0216336146327,-651.6669553526682,422.0216336146327,-651.6669553526682L425.6709815283797,-655.8376520582134L426.45298130886687,-659.226352884473C426.45298130886687,-659.226352884473,426.7136596059677,-661.5723795343465,430.8843407067061,-661.5723795343465C435.0550296098479,-661.5723795343465,436.8797113691247,-658.7049962902714,437.4010523585196,-654.2736602996423C437.9223816443094,-649.8422852969964,442.09307054745113,-641.5009308979229,443.91774840552637,-640.7189350186375C445.74243016480324,-639.936900127335,447.82776681397075,-629.5101973754889,444.1784267026272,-626.6428531434308C440.52906708527513,-623.7755089113728,437.401060160923,-621.4294822614993,437.401060160923,-621.4294822614993C437.401060160923,-621.4294822614993,436.8797191715282,-626.3821748463301,435.8370488963436,-626.3821748463301C434.7943708187556,-626.3821748463301,421.7609709223388,-620.6474863822139,421.7609709223388,-620.6474863822139C421.7609709223388,-620.6474863822139,424.6283229568003,-615.6947937973832,422.28230020812856,-614.6521196209969C419.9362930642636,-613.6094454446106,417.53365607662863,-616.2112348774521,410.291574488098,-612.8274495653251C403.0494928995674,-609.4436642531981,403.55047741853014,-609.1058201866174,403.55047741853014,-609.1058201866174L378.4220609772339,-626.6452718884802L371.8843764651209,-641.0574813015228L362.8614743279435,-661.9560237087984C362.8614743279435,-661.9560237087984,353.9872664932803,-671.7384039890917,353.9872664932803,-671.7384039890917C353.9872664932803,-671.7384039890917,353.9872664932803,-671.7384039890917,353.9872664932803,-671.7384039890917L350.787438445767,-679.649026709283L349.8524686457106,-683.2268968056177L345.7488374984632,-687.3341599716409C345.7488374984632,-687.3341599716409,342.63130530065575,-690.1959644972956,340.9753583169881,-694.9459116301608C339.3194113333204,-699.6958977750429,334.43715884625163,-716.3126762645845,334.43715884625163,-716.3126762645845"
                },
                {
                    "id": "id5",
                    "name": "Westlands",
                    "path": "M124.07801437447701,-741.5976128189905L141.2821074653575,-767.664350192597C141.2821074653575,-767.664350192597,139.19676301378664,-778.0910919564601,140.76077154752488,-778.6124095386447C142.32477930102283,-779.1337271208295,146.75613869886206,-780.4370795943165,146.75613869886206,-780.4370795943165L148.84148315043294,-807.0252125741417C148.84148315043294,-807.0252125741417,186.1170166852134,-796.5985098222957,191.59104635823724,-798.9445364721691C197.06507603126107,-801.2905241100254,206.449128013931,-842.4760916580572,212.18382818165222,-842.2154211633598C217.91852834937347,-841.9547428662589,240.33597242605683,-823.186654505726,242.94266176822427,-824.7506657703054C245.5493433079883,-826.3146653312798,246.85268017666866,-831.5280323120096,246.85268017666866,-831.5280323120096L261.45008743646326,-823.7079837915157C261.45008743646326,-823.7079837915157,274.7441656299809,-851.3388104537356,276.3081768945604,-852.3814768277185C277.8721842579381,-853.4241471029031,286.9955618447089,-860.201517545809,287.2562323394064,-862.5475363932791C287.5169106365072,-864.8935474383456,284.649554700844,-866.4575548017234,284.649554700844,-866.4575548017234L282.303535853374,-865.1542140318414L279.95752480830737,-869.0642363414875L274.48349513528353,-868.5428953520926C274.48349513528353,-868.5428953520926,273.96215414588875,-874.2775916186122,276.047506399863,-877.1449436530736C278.1328430490305,-880.0122917863333,292.2089210230353,-904.7757586116885,292.2089210230353,-904.7757586116885L386.83144063022144,-850.5567989696433C386.83144063022144,-850.5567989696433,387.35276991601125,-833.8740433570762,390.48079244517015,-830.746024729119C393.60881107312736,-827.6180021999601,407.6848890471322,-808.067886750528,407.6848890471322,-808.067886750528C407.6848890471322,-808.067886750528,405.5995367931579,-785.9111287733488,409.24889641050993,-780.6977578914174C412.89824432425684,-775.4843870094859,414.72292608353376,-773.1383603596124,414.2015850941389,-771.0530510188569C413.68025580834916,-768.9677026660842,407.6848890471322,-766.8823543133116,407.9455556406279,-765.5790018398245C408.2062339377287,-764.2756493663373,409.24889641050993,-757.7589650229356,407.9455556406279,-755.4129383730623C406.64221877194757,-753.066950735206,404.38596657542473,-732.6375278314677,404.4714106948965,-738.5512034292412C404.5568860239818,-744.4648790270146,402.27629032889695,-739.2668788797521,402.27629032889695,-739.2668788797521C402.27629032889695,-739.2668788797521,396.9545596687513,-744.7634770045678,395.0210148762419,-740.3131811737125C393.0874700837325,-735.8628463308404,393.0874700837325,-735.8628463308404,393.0874700837325,-735.8628463308404L393.0874700837325,-735.8628463308404L381.3334263691915,-729.6671138506904L375.82805834297085,-728.6526453625418L365.19598463042024,-728.5640880841194L364.15331825643733,-725.1754262698765L341.4751919814515,-725.1754262698765L334.4371510438482,-716.3127152766016L322.9677546096074,-723.090077917104L321.589549779244,-730.4547664724303L318.3165195831704,-734.0914666902897L308.37034734981273,-739.512147430167L307.8490102616196,-743.6828441357121L295.0762730574968,-741.5974957829395L293.251603001825,-744.2042007299137C293.251603001825,-744.2042007299137,273.9814885014773,-748.3540650184203,270.8559471365949,-748.5948471868888C267.7304057717125,-748.8355513313235,261.44148138552936,-748.7134437183445,261.44148138552936,-748.7134437183445C261.44148138552936,-748.7134437183445,252.6435420439568,-745.8439148133385,252.15346918612835,-745.8205466151998C251.6633924270981,-745.797139405044,247.74445587158445,-746.6319185432307,245.900451460324,-746.4410717564276C244.05645095026532,-746.2503029936586,239.05214156583958,-745.2383312745933,239.05214156583958,-745.2383312745933L233.6985810010838,-742.3665396726057L227.47809149499253,-739.7862458610904L220.5165063081612,-739.2644991467195L208.61294903875054,-738.160654127793C208.61294903875054,-738.160654127793,203.36566110930343,-734.3604545469958,207.58852078268058,-733.4442183174672C211.81138435725947,-732.5279820879389,214.866395896741,-730.4120093018792,214.866395896741,-730.4120093018792C214.866395896741,-730.4120093018792,218.15741843502093,-729.1875391266168,217.97164321041836,-726.1637567066847C217.78586798581586,-723.1399352747356,217.12685748989017,-721.9138656067794,217.12685748989017,-721.9138656067794C217.12685748989017,-721.9138656067794,212.98629756742045,-719.9510149871548,211.82769138033458,-719.3435978836143C210.66908519324872,-718.7361807800734,208.50047739395228,-715.6863773448515,206.99198022945882,-714.9126910251713C205.4834791637636,-714.1389656934742,198.36226070487203,-713.038124599851,198.36226070487203,-713.038124599851L188.72369822497737,-715.0094018151314L183.04849528427027,-710.2404168180061L177.422069068326,-706.6508041045765L173.11225941162368,-706.7986596487268L165.0029016748069,-709.2746353269813L162.65689062974027,-711.0993053826531L162.65689062974027,-711.0993053826531C162.65689062974027,-711.0993053826531,162.65689062974027,-711.0993053826531,162.65689062974027,-711.0993053826531L153.9835751762385,-713.8597957003503L145.1325170724193,-722.2496420364631L139.16767799468738,-725.8964853787234L132.93041995336077,-725.5664437155277L127.49748592908728,-727.2908138756825C127.49748592908728,-727.2908138756825,124.8486351298672,-726.9490686074091,124.4633247521721,-734.2734577492505C124.07801476459719,-741.5976518310074,124.07801476459719,-741.5976518310074,124.07801476459719,-741.5976518310074"
                },
                {
                    "id": "id6",
                    "name": "Embakasi South",
                    "path": "M445.1886896953511,-627.8514844398212L468.6812152308814,-630.5529495759091L474.9372524867958,-627.1642487496495L479.6292706757273,-629.5102753995228L479.10794138993754,-636.2876380400254C479.10794138993754,-636.2876380400254,487.18864870152373,-628.2069229260358,490.8380005164724,-630.2922712788084C494.4873601338244,-632.3776196315811,507.520763931443,-643.0650006805279,507.520763931443,-643.0650006805279L522.6395199830358,-623.514908638306L536.4549235611415,-602.1401075283952L531.7629092734118,-597.4480932406656L528.374208447152,-595.6234231849937L522.9001592681198,-596.9267366464638L522.9001592681198,-594.8414273057082L495.7907087061099,-577.6373229013428L554.7017021418933,-515.3376676513165L551.3130013156336,-508.82094429589796C551.3130013156336,-508.82094429589796,569.7106783778559,-483.9887421979206,570.5705812549429,-483.0506592389135C571.43048413203,-482.1126152919232,561.6277785909184,-490.95379165185506,561.6277785909184,-490.95379165185506L544.0451015743013,-504.7255797950373L522.3788416859351,-521.3329954005167L515.080122451231,-520.2903212241304L509.4424178611933,-528.3704901698829L503.63243620440954,-536.0588224176289L495.4555954807139,-545.8207994130696L488.25238546584853,-553.1973866335584L484.5787096583464,-556.3961769614214L477.1414587515374,-561.3826539529101L469.88423659923774,-565.5246378139976L459.1682948526992,-571.4507582451706L451.1993452660015,-575.780975087927L440.21825444522244,-581.680645371624L422.28228460332167,-591.1920481823479L424.36764465969935,-595.362744887893L403.5504696161266,-609.1058201866176L408.703453797058,-612.0751028189038L413.9295503989108,-614.174378461719L418.35104365766944,-614.6037057079917L421.6472899050158,-614.4527292024874L423.1308388846849,-615.6833242644071L421.7609631199353,-620.6474473701971L428.7398579386768,-623.6550007910879L435.89885953596144,-626.3763230437913L437.4010523585196,-621.4294432494827"
                },
                {
                    "id": "id7",
                    "name": "Makadara",
                    "path": "M507.520763931443,-643.0650006805278L509.34543398711486,-649.0603674417448L506.7387680521576,-655.3164125000626L505.9567721728721,-661.3117792612795L504.653419699385,-665.4824759668246L506.99940733724145,-668.8711377810675L500.22204469673903,-689.7245822967766L495.00868941961437,-689.7245822967766L491.88067859406056,-687.1179163618192L488.23131897670856,-696.7626232343797L480.9326114456096,-693.8952790023217L478.0652711147532,-696.7626232343797L462.94651506316035,-685.0325680090466L455.1264782462716,-693.8952790023217L438.96505191949416,-682.4259020740893L427.75632207874906,-679.5585188300143L427.4956827936652,-672.7811561895118L425.1496639461952,-668.8711377810674L412.63759723676975,-670.95648613384L402.60458815493604,-675.400032885767L402.339267427821,-673.8645589115691L396.72191540701374,-672.784238138849L406.9029009702502,-657.4016828288012L408.46691223482964,-652.7096685410714L415.79561610574314,-653.154951702267L416.30184383978076,-653.1783589124226L422.021657021843,-651.6655899320758L425.6709971331866,-655.8362866376209L426.45299691367376,-659.2249874638806C426.45299691367376,-659.2249874638806,433.5156232243439,-664.7737836673435,435.4401640433467,-659.6682810122129C437.3647087635512,-654.5628173690993,438.5341954021578,-649.9684891717526,438.5341954021578,-649.9684891717526L441.4127867986957,-643.7976073463847L444.54566632396194,-640.0956010121907L445.8476026612346,-636.2571306427891L446.17347003861903,-633.4044939411123L445.18870920135964,-627.8501190192288L468.6812347368899,-630.5515841553168L474.93727199280426,-627.1628833290572L479.62928237933244,-629.5089099789305L479.1079608959461,-636.2862726194329L485.3768409078326,-631.3556218241656L489.03257898995207,-629.9670280936947L491.9986587356487,-631.0244098004622"
                },
                {
                    "id": "id8",
                    "name": "Embakasi West",
                    "path": "M506.99940733724134,-668.8711377810675L506.99940733724134,-668.8711377810675L533.6699727088316,-685.1636873979355L533.301309148879,-692.1678659048468L541.0427367516616,-699.5406689596938L532.564021040991,-722.7649907800583L544.3605137311494,-730.8750819427933C544.3605137311494,-730.8750819427933,558.0002071850196,-744.8834389566158,559.4747834007957,-745.6207270645039C560.9493206045549,-746.3579761603751,567.5848355515137,-748.9384650319748,567.5848355515137,-748.9384650319748L562.0552332603786,-754.8367308830625C562.0552332603786,-754.8367308830625,552.83922944182,-758.523132410486,550.9960286781081,-757.4171807426454C549.1528279143965,-756.3112680868218,546.2037144948611,-752.9935301193508,546.2037144948611,-752.9935301193508L535.5131344605263,-754.4680673231101L528.5089949656319,-755.2053554309981L523.7166417703679,-751.8875784515103L519.2929521350563,-752.9935301193508L508.6024111127385,-743.4088627408398L489.4331036641281,-741.565661977128L481.69165655533715,-726.4513923074816L472.4756488355768,-716.8667639409874L480.5857360971101,-709.4939608861405L483.53485341784716,-703.9643585950053L488.23127216228795,-696.7626232343797L491.88062787843825,-687.1179163618192C491.88062787843825,-687.1179163618192,495.0086504075971,-689.7245822967766,495.0086504075971,-689.7245822967766L500.22200568472175,-689.7245822967766"
                },
                {
                    "id": "id9",
                    "name": "Embakasi Central",
                    "path": "M567.5848355515138,-748.9384650319748L584.1737204489533,-753.3621546672864L593.0210607075594,-754.4680673231101L614.402220776229,-764.0527347016213L613.664932668341,-755.9426435388863L617.3513341957645,-753.3621546672864L617.3513341957645,-747.4638888161987L622.8809364868996,-732.3496581585692C622.8809364868996,-732.3496581585692,615.139508884117,-731.9809945986168,613.2963081204053,-731.9809945986168C611.4530683446768,-731.9809945986168,605.9235050655584,-727.5573439753223,605.9235050655584,-727.5573439753223L603.7116407418943,-715.0235631772757L594.864300483288,-708.7566727782524L583.0677687811127,-711.3371616498523L572.0085641988422,-712.8116988536116L563.5298484881718,-708.3880482303169L570.5340269950831,-696.2228919802061L562.4239358323481,-686.2696000537593L569.4281143392594,-672.2612820519536L552.4706439059013,-675.2103954714889L542.8859765273902,-667.4689678687064L506.99940733724134,-668.8711377810675L533.6699727088316,-685.1636873979355L533.301309148879,-692.1678659048468L541.0427367516616,-699.5406689596938L532.564021040991,-722.7649907800583L552.7974085596751,-739.3988955450304L557.8658497987259,-744.2931871405226"
                },
                {
                    "id": "id10",
                    "name": "Kamkunji",
                    "path": "M408.2537505743448,-727.527850890526L420.8660430564552,-733.0869462664574L433.76845620484073,-732.7182827065049L440.40397895420296,-732.7182827065049L452.20046774315966,-741.1970374291925L459.57327860041,-746.3579761603751L472.10703989244803,-752.2562420114627L486.1153774002622,-752.9935301193508L489.4331036641281,-741.565661977128L481.69165655533715,-726.4513923074816L472.4756488355768,-716.8667639409874L480.5857321959084,-709.4939608861405L483.53485341784716,-703.9643585950053L488.23126826108626,-696.7626232343797L480.93261144560927,-693.8952790023217L478.0652633123495,-696.7626232343797L462.94651506316006,-685.0325680090466L455.12647824627135,-693.8952790023217L438.9650519194939,-682.4259020740893L427.7563220787488,-679.5585188300143L427.4956827936649,-672.7811561895118L425.1496639461949,-668.8711377810674L412.63759723676947,-670.95648613384L402.60458815493575,-675.400032885767L402.60458815493575,-675.400032885767L402.60458815493575,-675.400032885767L395.9548182169921,-685.2931682821136L395.9548182169921,-685.2931682821136L397.29231400769305,-692.1722742627595L405.07526600129177,-693.5058610493644L410.3882930804612,-697.5285071506747L411.328931326577,-708.7173486651908L410.6322196174939,-715.4055298349999"
                },
                {
                    "id": "id11",
                    "name": "Embakasi North",
                    "path": "M536.9602072043696,-754.2684818445157L542.8859765273902,-761.4722458300214L542.8859765273902,-767.0018481211565L550.9960676901251,-770.68824964858L572.7458523067303,-784.3279431024503L576.4322538341538,-788.0143446298736L579.7500308136416,-785.8025193182262L599.2879511065826,-787.6457200819381L601.1311518702943,-798.336261104256L575.3263411783302,-796.4930603405442L560.2120715086838,-798.336261104256L539.1995749999668,-789.4889208456498L530.3521957293436,-782.853366886674L523.3480562344494,-783.2220304466265L522.6107681265613,-769.950961540692L517.4497903833616,-762.578158485845L509.7083627805791,-761.840870377957L506.0219612531556,-771.7941623044036L496.805957434597,-774.3746511760035L486.8526616069486,-767.0018481211565L486.1153774002622,-752.9935301193508L489.4331036641281,-741.5656619771279L508.6024111127385,-743.4088627408397L519.2929521350563,-752.9935301193508L523.7166417703679,-751.8875784515102L528.5089949656319,-755.2053554309981"
                },
                {
                    "id": "id12",
                    "name": "Embakasi East",
                    "path": "M554.7017021418933,-515.3376676513165L615.5081334320527,-568.6733367121273L677.4397103023803,-545.4490148917629L686.2870895730033,-532.9152340937163L726.1002182667734,-622.1261978717844L706.1936734258969,-680.739997762624L740.108575280596,-694.0110666685586L735.6848856452846,-702.8584459391817L719.8333278677502,-725.3454796516579L691.0794037562506,-744.8834389566158C691.0794037562506,-744.8834389566158,633.9401410691701,-747.8325523761512,631.7283157575228,-746.7266397203275C629.5164514338586,-745.6207270645039,617.3513341957646,-747.4638888161987,617.3513341957646,-747.4638888161987L622.8809364868997,-732.3496581585692L614.0506834917072,-731.9923080835254L605.9235050655585,-727.557421999356L603.7116407418944,-715.0236412013096L594.8643004832882,-708.7567508022863L572.0085641988424,-712.8117768776452L563.5298484881719,-708.3881262543507L570.5340269950832,-696.2229700042398L562.4239358323482,-686.2696780777931L569.4281143392595,-672.2613600759872L552.4706439059014,-675.2104734955227L542.8859765273903,-667.4690458927403L506.99940733724145,-668.8712158051014L504.653419699385,-665.4825539908585L505.9567721728721,-661.3118572853134L506.7387680521576,-655.3164905240964L509.34543398711486,-649.0604454657787L507.520763931443,-643.0650787045615L517.8585973087312,-629.6972209846332L522.6395199830359,-623.5149866623398L528.0866508703891,-615.0873766938425L536.4549235611415,-602.1401855524291L531.7629092734118,-597.4481712646993C531.7629092734118,-597.4481712646993,528.374208447152,-595.6235012090275,528.374208447152,-595.6235012090275L522.9001592681198,-596.9268146704977L522.9001592681198,-594.841505329742L495.7907087061099,-577.6374009253767"
                },
                {
                    "id": "id13",
                    "name": "Kasarani",
                    "path": "M740.1085752805959,-694.0110666685587L753.3796051745136,-700.2779570675818L769.968451059936,-654.9351870706598L824.1585613154642,-675.5790200194244L935.8565978180254,-646.8250959079248L936.5938469138965,-656.4097632864359L929.5897074190021,-655.3038116185954L927.0092185474023,-659.727501253907L929.2210438590496,-663.7825663412829L930.6956200748257,-669.3121686324181L937.699798581737,-677.0535962352005C937.699798581737,-677.0535962352005,935.1193097101373,-686.6382636137117,936.2252223659609,-688.1128008174709C937.3311350217845,-689.5873770332471,941.3862001091605,-695.4856428843348,941.3862001091605,-695.4856428843348L946.9158024002957,-693.2737785606705L945.809889744472,-689.5873770332471C945.809889744472,-689.5873770332471,950.6022039277192,-686.6382636137116,952.0767411314783,-689.5873770332471C953.5513173472546,-692.5364904527825,954.6572300030782,-702.8584459391817,954.6572300030782,-702.8584459391817L960.5554958541659,-707.6507601224288L967.5596353490603,-710.2312489940286L973.457901200148,-713.5489869614996L977.8815908354594,-712.0744497577404C977.8815908354594,-712.0744497577404,981.1993288029304,-712.8116988536115,982.305280470771,-714.6549386293401C983.4111931265946,-716.498100381035,982.305280470771,-716.498100381035,984.5171057824183,-717.235388488923C986.7289310940655,-717.9726765968111,989.3094199656655,-713.5489869614996,989.3094199656655,-713.5489869614996L994.8390612688175,-714.2862750693877L994.8390612688175,-721.290453576299L996.3135984725768,-724.9768551037224L996.3135984725768,-727.5573439753223L997.4195111284005,-731.9809945986168L1000,-734.9301470301692L1000,-737.8792604497045L962.030033057925,-769.950961540692L962.3986966178776,-774.7432757239392L979.7247915991711,-781.7474542308505L963.8732728336537,-807.9209284827671L946.5471388403431,-799.8108373200321L906.7340101465732,-872.4329825210895L894.9375174564148,-863.2169748013291L890.5138278211032,-867.2720164814949L885.7215136378561,-869.11522504761L879.8232477867684,-865.7974558705256L875.399558151457,-866.1660804184611L870.6072439682098,-861.742398585553L861.3912401496513,-861.3737740376174L838.904167425158,-846.9967924758591L837.7982547693343,-841.8358264362646L835.2177658977346,-839.623993322214L834.849102337782,-835.2003036869024L828.5822119387587,-836.6748642978719L823.0526096476235,-833.3571068243924L820.4721207760238,-832.2511824649637L817.5230073564883,-831.5138982582773L815.3111430328241,-831.5138982582773L814.9424794728716,-826.3529322186828L814.9424794728716,-823.4038148979457L810.1501652896244,-823.7724394458812L804.6205629984893,-824.8783638053101L803.1459867827131,-823.4038031943405L802.408698674825,-818.2428449571495L795.7731837278662,-818.611508517102L794.6672710720427,-817.1369323013258L792.4554067483784,-812.7132426660143L792.0867431884259,-803.8658633953912L790.2435424247142,-804.2345269553438L788.768966208938,-800.9167499758557L780.6588750462031,-802.391326191632L771.8115347875969,-802.391326191632L752.6422390425915,-810.501417354367L744.5321478798566,-827.0902086229657C744.5321478798566,-827.0902086229657,731.2610789739219,-832.2511707613585,728.3119655543866,-831.1452503031315C725.3628521348512,-830.0393259437028,721.3077870474752,-827.8274928296522,721.3077870474752,-827.8274928296522L714.3036085405639,-829.6706896921622L704.3503166141172,-823.4038031943405L689.2360859564878,-816.031019645502L678.9141694821056,-822.2978788349119C678.9141694821056,-822.2978788349119,674.8591043947296,-823.7724394458812,672.6472790830824,-822.2978788349119C670.4354147594181,-820.8233338287492,665.643100576171,-816.3996441934377,665.643100576171,-816.3996441934377L661.9566990487475,-821.5606063318306L657.9016339613715,-824.1410874010269L647.2110929390536,-823.0351630415983L624.7240202145605,-834.8316557317567C624.7240202145605,-834.8316557317567,610.3470776648192,-832.2511707613585,608.5038378890905,-832.9884549680448C606.6606371253788,-833.7257313723279,595.2328079951728,-843.3103870472339,595.2328079951728,-843.3103870472339L584.9108915207905,-843.3103870472339L580.1185383255265,-850.6831862008792L572.7457352706796,-854.738227881045L567.2161329795445,-866.1660804184611L553.5764395256742,-860.636478127326L537.7249207601567,-856.2127962944178L521.8733629826223,-847.7340649789404L510.8141584003519,-837.4121368009531L502.7040672376169,-827.8274928296522L486.1152603642114,-816.7683077533902C486.1152603642114,-816.7683077533902,473.5814834673666,-809.3954656865263,473.2128472158259,-807.9209284827672C472.84422266789034,-806.446352266991,469.1578055356601,-802.3913261916321,469.1578055356601,-802.3913261916321L466.2086843137214,-797.9676365563205C466.2086843137214,-797.9676365563205,473.9501314225123,-795.3871476847207,475.42469203348173,-795.3871476847207C476.8992526444511,-795.3871476847207,479.84836996518817,-789.8575453935855,479.84836996518817,-789.8575453935855L481.32293057615755,-794.2812350288971L492.01350670929065,-793.1753223730734L498.64904116225796,-796.4930603405444L504.17864345339314,-799.4422127720966L506.3904687650404,-797.9676365563205L525.9284280699983,-796.8617239004968L529.6148295974218,-804.6031515032794L535.1444318885569,-804.6031515032794L537.7249207601567,-806.0777277190555L541.0426587276277,-804.2345269553438L545.4663483629391,-804.6031905152963L548.784125342427,-808.2895920427197L551.3646142140268,-807.9209284827672L560.211954472633,-798.3362611042561L575.3262241422793,-796.4930603405444L584.9932068765047,-797.183573040138L601.1310348342435,-798.3362611042561L599.2878340705317,-787.6457200819382C599.2878340705317,-787.6457200819382,583.0676907570788,-783.5906940065793,579.7499137775908,-785.8025193182265C576.432136798103,-788.0143446298738,576.432136798103,-788.0143446298738,576.432136798103,-788.0143446298738L572.7457352706795,-784.3279431024504L550.9959506540744,-770.6882496485803L542.8858594913394,-767.0018481211566L542.8858594913394,-761.4722458300215L536.9600901683187,-754.2684818445157L546.2035974588103,-752.993530119351L551.6332119505638,-757.6025658470788L562.0551162243279,-754.8367308830627L567.584718515463,-748.938465031975L575.9595062130421,-751.1717469529318L584.1736034129024,-753.3621546672866L593.0209436715085,-754.4680673231103L614.4021037401781,-764.0527347016214L613.66481563229,-755.9426435388864L617.3512171597135,-753.3621546672866L617.3512171597135,-747.463888816199L631.029337450256,-746.5175353096033L632.6580891569245,-746.8803470670169L650.8823968159267,-746.6497860469832L660.8474703714851,-746.2764410449995L669.2777331571334,-745.9194810901249L678.1373622010713,-745.516174859142L691.0792867201995,-744.8836340167006L700.9732413689015,-738.1608101758611L719.8332108316991,-725.3456747117428L726.2734316219255,-716.209567503849L735.6847686092335,-702.8586409992665"
                },
                {
                    "id": "id14",
                    "name": "Ruaraka",
                    "path": "M466.20867651131806,-797.9676365563205L450.72590713219034,-766.2645600132685L425.2897209881618,-750.413041247751L435.98028931889144,-752.9935301193508L438.9294183432336,-755.2053554309981L441.141255358486,-752.2562420114627L442.9844600233994,-753.3621546672864L445.5649449937975,-755.2053554309981L448.8827024672769,-752.6248665593982L454.7809488123561,-753.7307792152219L456.9927936300118,-754.4680673231101L462.52239592114705,-757.0485561947098L471.7384036409074,-759.9976696142452L476.5307334289613,-762.578158485845L486.8526616069487,-767.0018481211565L496.80595743459713,-774.3746511760035L506.0219612531557,-771.7941623044036L509.7083627805792,-761.8408703779569L517.4497903833617,-762.578158485845L522.6107681265614,-769.9509615406919L523.3480562344494,-783.2220304466265L530.3521957293437,-782.8533668866739L539.1995749999669,-789.4889208456498L560.2119544726332,-798.3362611042559L551.364614214027,-807.9209284827671L548.7841253424273,-808.2895920427195L545.4663483629394,-804.6031905152961L541.0426587276279,-804.2345269553435L537.7249207601569,-806.0777277190552L535.1444318885572,-804.6031515032792L529.614829597422,-804.6031515032792L525.9284280699985,-796.8617239004967L506.3904687650406,-797.9676365563204L504.17864345339336,-799.4422127720965L492.01350280808924,-793.1753223730732L481.32292277375444,-794.2812350288968L479.8483660639867,-789.8575453935853L479.8483660639867,-789.8575453935853L476.2744283789581,-794.9691339233564"
                },
                {
                    "id": "id15",
                    "name": "Mathare",
                    "path": "M402.2762903288969,-739.2668788797521C402.2762903288969,-739.2668788797521,409.6170372094356,-750.416825413393,418.2470376205442,-750.9095471871707C426.87703022924944,-751.4022299489316,425.2897131857583,-750.4130412477512,425.2897131857583,-750.4130412477512L435.9802893188914,-752.9935301193508L438.9294183432335,-755.2053554309981L441.1412553584859,-752.2562420114627L445.5649449937975,-755.2053554309981L448.8827024672769,-752.6248665593984L454.7809410099527,-753.730779215222L462.52238811874366,-757.0485561947098C462.52238811874366,-757.0485561947098,471.738395838504,-759.9976696142452,471.738395838504,-759.9976696142452L476.5307334289613,-762.578158485845L486.8526616069487,-767.0018481211565L486.11537740026233,-752.9935301193508L472.10703209004475,-752.2562420114626L464.48046756869803,-748.6672534903039L459.57327860041005,-746.357976160375L453.8712275896543,-742.3665786846226L449.2563439605892,-739.0809476070818L445.04255067994563,-736.052288685034L440.403978954203,-732.7182827065049L420.8660430564553,-733.0869462664573L408.25375057434485,-727.5278508905259L407.94555564062796,-737.6874383624784"
                },
                {
                    "id": "id16",
                    "name": "Roysambu",
                    "path": "M386.83144063022144,-850.5567989696433L382.5386948297227,-853.0165573524616L382.7973054899264,-852.8683897121759L383.63596242259547,-852.3878318852758L385.5829702621461,-856.0323501113273C385.5829702621461,-856.0323501113273,381.6520687210411,-859.5701587674806,381.6520687210411,-860.5528909798599C381.6520687210411,-861.5356075874322,379.4900773598153,-865.0734201447872,379.4900773598153,-865.0734201447872L377.91771752361365,-868.8077713422147L379.09698837606527,-870.3801311784163C379.09698837606527,-870.3801311784163,381.0624371960169,-869.5939493097146,383.22442855724273,-868.414678457263C385.3864277208719,-867.2354076048113,386.95878755707355,-862.5183280962065,386.95878755707355,-862.5183280962065L390.6931387545009,-858.9805272424564L394.8205789356784,-857.8012602912065L399.930751329235,-862.3217894561338L421.94378123365476,-853.280719422674L422.7299631023564,-863.697598948658L424.69541192230804,-865.8595981122872L424.8919544635822,-875.6868383108437L426.2677756597114,-878.6350193431745C426.2677756597114,-878.6350193431745,432.1641143171629,-878.6350193431745,434.91574500581623,-879.8142901956262C437.66737569446957,-880.9935493444727,441.9913662193245,-879.4212012118762,441.9913662193245,-879.4212012118762L446.1188064005019,-874.7041217032712L447.10152690927606,-886.6933610654569L452.99787727033265,-905.7582138387475L458.50113864763927,-903.0065831500941C458.50113864763927,-903.0065831500941,459.2873166151393,-899.2722319526667,460.073498483841,-899.0756816089893C460.85967645134093,-898.879139067715,464.3974890086959,-899.2722241502634,464.3974890086959,-899.2722241502634L468.7214678299458,-896.7171438052876L471.0800095348491,-893.7689627729568L472.8489197147283,-895.5378729528359L475.9936276835266,-892.9827848054567L506.06503051984214,-892.5896919205051C506.06503051984214,-892.5896919205051,512.747554947197,-898.6825926252392,513.5337251122936,-899.0756738065859C514.3198952773902,-899.4687627903357,518.6439092094553,-900.844583986465,518.6439092094553,-900.844583986465L518.6439092094553,-898.8791351665134L523.3609692120517,-898.0929532978117L526.3091463431808,-900.058406018965L534.5640501127459,-899.0756738065859L527.0953165082775,-907.7236548562958L526.7022314257292,-921.4817965959571L509.40629273351954,-943.8879154841269L512.3544698646486,-946.6395461727802C512.3544698646486,-946.6395461727802,514.7129803599383,-945.2637366802561,515.8922746196002,-946.2464571890303C517.0715298672451,-947.2291776978043,524.9333485542618,-956.0736973875867,524.9333485542618,-956.0736973875867C524.9333485542618,-956.0736973875867,532.008958064165,-973.173109143329,532.7951282292615,-973.173109143329C533.5812983943581,-973.173109143329,535.5467628191166,-972.1903886345549,536.3329329842131,-972.1903886345549C537.1191421613266,-972.1903886345549,537.708769785149,-973.566198127079,537.708769785149,-973.566198127079L543.4085424941162,-974.1558413557082L543.9982091299556,-976.9074603407564L547.5360138849072,-971.6007493071273L550.4841910160363,-971.6007493071273L550.8772760985846,-968.849118618474L556.3805062662777,-969.0456611597482L555.5943361011812,-971.207652520974L577.6073738080042,-971.207652520974L582.5209763518749,-969.2421997998207L585.272571929713,-962.7562218149416L587.4346179077626,-961.57695096249L590.77588012144,-962.7562218149416L594.7067699589398,-960.5942304537158L595.6894826653106,-957.646049421385L599.4238299615364,-953.3220706001351L604.5339750466812,-955.8771509451109L610.4303293089395,-953.7151595838851L615.9335984886494,-952.3393383877559L617.899023901391,-948.8015297316026L621.0437825858112,-948.8015297316026L625.3677965178763,-946.8360809116509L628.7090587315538,-942.1190092054494L631.8537784039571,-941.3328312379494L628.905601272828,-933.667578499417C628.905601272828,-933.667578499417,574.6591966768754,-876.2764659346661,573.8730265117787,-875.686822706037C573.0868173346653,-875.0971950822145,567.2161719915613,-866.1660726160576,567.2161719915613,-866.1660726160576L553.5764785376911,-860.6364703249225L537.7249597721735,-856.2127923932161L521.8734019946392,-847.7340610777387L510.81419741236874,-837.4121289985496L502.70410624963375,-827.8274850272486L486.707131179007,-817.1628752925816L473.4564577555214,-808.3079667026918L472.37434633122444,-806.3622423584981L466.2086960173263,-797.9676365563204L450.7259188357952,-766.2645600132684L443.8137228623924,-761.9569701403293L436.2101988382423,-757.2185315524572L425.2897326917666,-750.4130412477509L419.76892370924656,-750.9860497523628L416.261388378228,-750.6119245100407L411.8996498257953,-748.757059153268L406.1757364807541,-744.0443684965672L407.05545356123804,-752.0892705790186L408.47331800800856,-757.2627711796515L408.4588835617459,-761.8412604981262L407.95365453534157,-765.5377271259166L412.85735582931636,-769.4139611277029L414.1090446887881,-770.7933480221791L414.2036098178172,-772.5272371144637L413.39918983120253,-774.5045611923676L411.2645536962454,-777.8220650877371L408.6668527227778,-781.7760500392573L407.5533249212502,-786.4499237391165L407.09437194932366,-795.8904417150852L407.68477591228293,-808.0679647745619L400.13194020172506,-818.401077697802L392.29860808946785,-828.6526047900443L389.3862127802634,-832.5920304568475L387.9226028424452,-838.5681798985268"
                },
                {
                    "id": "id17",
                    "name": "Langata",
                    "path": "M32.322844851151494,-657.9230784350199L26.066811496438792,-645.4110273304013L10.426726159056194,-648.5390498595601L0,-614.1308410508292L19.810778141726093,-607.8748350045283L10.426726159056194,-599.533441593438L22.938796769683282,-587.0213904888194L33.365519027537786,-597.4480932406656L36.49353375429329,-575.5519745485702L46.92025991334948,-579.7226712541153L47.96293018853408,-559.9119009147926L58.38965244638859,-541.1438047518562L64.64568970230299,-534.8877596935384L69.8590473201487,-535.9304338699247L83.41378742572006,-542.1864789282425L96.96852675105107,-526.546366282448L118.86464544314639,-512.9916410014431L149.1021380403236,-484.83947725102996L176.2116276143504,-468.1567294408662L184.55300542063398,-477.54079702834287L200.1930907580166,-460.8580102061621L218.96119862455805,-460.8580102061621L225.21722807806907NaNL540.2390367848733NaNL595.500666702103NaNL602.799374233202NaNC713.3226418700648NaNNaNNaNNaNNaNL772.7549723940414NaNC772.7549723940414NaNNaNNaNNaNNaNL811.3338466987038NaNC811.3338466987038NaNNaNNaNNaNNaNL912.4730467480899NaNC912.4730467480899NaNNaNNaNNaNNaNL966.6920258961435NaNL966.6920258961435NaNL980.2467511771484NaNC984.4174478826935NaNNaNNaNNaNNaNL914.5583951008624NaNC914.5583951008624NaNNaNNaNNaNNaNL820.7178752741634NaNC820.7178752741634NaNNaNNaNNaNNaNL730.0053974826317NaNC730.0053974826317NaNNaNNaNNaNNaNL625.73815929928NaNL601.7567039580173NaNL588.201959171004NaNC588.201959171004NaNNaNNaNNaNNaNL521.4709328195335NaNC521.4709328195335NaNNaNNaNNaNNaNL455.7825611384408NaNC457.8679133924151NaNNaNNaNNaNNaNL443.2705061326205NaNC443.2705061326205NaNNaNNaNNaNNaNL352.55801273628214NaN"
                },
                {
                    "id": "id18",
                    "name": "Unmatched",
                    "path": "M730.5731410674456,-901.4291166408768C730.5731410674456,-901.4291166408768,720.8457287190015,-930.9580066662119,747.8959590393174,-940.7489929974388C774.9462283716502,-950.5399754274641,775.701110899172,-859.670645920679,730.5731410674456,-901.4291166408768"
                },
                {
                    "id": "id19",
                    "name": "Langata",
                    "path": "M10.426726159056187,-648.5390498595601L26.066815397640475,-645.4110273304013L32.3228370487481,-657.9231564590538L46.92025991334948,-655.8377300822473L54.2189557408434,-664.1792015173716L70.32910389233272,-662.1097310554878C70.32910389233272,-662.1097310554878,70.82634091694955,-664.6191790442651,78.30952808356895,-659.3792799908239C85.79271642054886,-654.1393809373825,99.05386379033878,-643.3257570016626,99.05386379033878,-643.3257570016626L103.04701555846835,-665.0813934208065L107.14657623088165,-660.2921221748798L123.24477074927664,-654.835199271278L137.63274550728448,-651.6671114007361L145.97411160996302,-666.2644718461104L156.10060908915864,-664.7758513042409L162.6932537307173,-662.6970569703117L164.8933013144546,-660.7812548431004L163.720007102996,-657.9407508786876C163.720007102996,-657.9407508786876,159.2967622046774,-655.0893235495354,158.69231001442301,-654.9121309686565C158.0878461205635,-654.7350164118117,152.2301527670791,-655.8378081062812,152.2301527670791,-655.8378081062812L150.1448122167099,-638.1123080956974L180.38230481388712,-645.4111053544352C180.38230481388712,-645.4111053544352,191.5516559247469,-646.6288654627862,195.9879893547442,-642.6778844365693C200.4243344883466,-638.7269424223693,202.64089585884872,-636.1036183561846,202.64089585884872,-636.1036183561846L215.8331799966009,-629.7709536966238L232.51593560916805,-634.9842855665383L241.60454958765595,-628.0908231636636L250.07601296437997,-622.2400739491919L257.13604887712626,-618.0797544401491L264.4540400481918,-615.9464993305912L272.4779458631334,-618.1686628267239L282.5642063480714,-624.5575828146924L296.1189511350848,-614.1308410508294L313.84437702283657,-614.1308410508294L292.9909325071276,-625.6002569910787L300.2896400382266,-637.0696339193111L314.8870472980212,-619.3442119327608L320.1004064763476,-624.5575828146923L323.2284251043048,-638.1123080956974C323.2284251043048,-638.1123080956974,345.1152511339683,-648.5177102863016,350.80509138342615,-646.9512997826812C356.49493943528734,-645.3848892790608,361.1261339886293,-640.560624253951,361.1261339886293,-640.560624253951C361.1261339886293,-640.560624253951,378.4220414712254,-626.6454279365482,378.4220531748305,-626.6453499125143C378.4220531748305,-626.6452718884805,403.55045791252167,-609.1058201866176,403.55045791252167,-609.1058201866176L424.36764465969947,-595.362744887893L422.2822846033218,-591.1920481823479L436.50788393459965,-583.6601931344928L454.2764141998532,-574.1089200424706L477.14145094913414,-561.3826539529101C477.14145094913414,-561.3826539529101,484.82487548515076,-556.7073758204416,488.25237766344526,-553.1973866335584C491.6798759405381,-549.6873974466752,502.685692577645,-537.5752975395839,506.5829930685714,-532.2291297520355C510.4802935594978,-526.8829229524705,515.0801224512311,-520.2903212241305,515.0801224512311,-520.2903212241305L522.3788416859352,-521.3329954005168L571.5284823185488,-482.00303053637765C571.5284823185488,-482.00303053637765,589.4147118388686,-461.71256843693055,587.0245235858347,-438.961891514067C584.6343353328009,-416.21121459120354,587.0245235858347,-438.961891514067,587.0245235858347,-438.961891514067C587.0245235858347,-438.961891514067,587.7599391169103,-445.84840977792896,592.0072944357155,-446.06192254656605C596.2546497545206,-446.27531827915226,599.4293306559233,-448.01993567609156,603.0518304996217,-443.46594590424655C606.6743303433201,-438.91199514441854,608.92064227793,-432.7058854677663,608.92064227793,-432.7058854677663L621.4326933825487,-429.5778629386074C621.4326933825487,-429.5778629386074,622.5589703112079,-433.9331254962304,624.9197825154962,-432.3871572894793C627.2805557077677,-430.84122809474525,628.656782628873,-430.26689318155786,631.3246974304044,-425.4640847657576C633.9926122319358,-420.6613153619743,643.1453775710571,-400.1322947790234,643.1453775710571,-400.1322947790234L652.3938783997152,-378.591419513058L657.7522179365444,-369.38407636225696L667.8184106399755,-357.48084679378843L678.7796950597611,-343.0360623466124L674.6089983542159,-324.2679271716591L661.054273073211,-334.69466893552203L661.054273073211,-347.20672004014074L650.627531309348,-345.12137168736814L641.6045979625571,-351.59974623014824C641.6045979625571,-351.59974623014824,634.6567528080873,-357.6954518988994,626.3501191040781,-355.833603391097C618.0434854000689,-353.9717158712776,606.8352939251574,-350.3347425692997,606.8352939251574,-350.3347425692997L507.7814422285438,-399.3403508354217L521.4442698084512,-403.74215472923765C521.4442698084512,-403.74215472923765,525.5997908394121,-405.73520064996285,524.3772712649961,-406.83514446719687C523.154790702597,-407.9350882844308,510.8189178664171,-412.89507611642665,505.6960938757713,-412.89507611642665C500.57326988512546,-412.89507611642665,485.88530012923843,-412.89507611642665,485.88530012923843,-412.89507611642665C485.88530012923843,-412.89507611642665,474.10372563435254,-405.0502276567729,471.4704144918347,-407.1168112294039C468.8371072505185,-409.18339480203497,468.1025967982356,-410.5394915224063,468.1025967982356,-410.5394915224063L467.1172156699071,-419.1511211747444L453.5624591792886,-418.1084469983581L435.2986284459385,-430.35693291662335C435.2986284459385,-430.35693291662335,424.73054224355025,-435.6363511432109,421.5141067804315,-436.79091178414143C418.2976596137077,-437.94547242507207,409.71045148396547,-442.62437867511466,408.6976644137463,-446.5278430647155C407.6848890471322,-450.4313074543163,406.64221877194757,-463.98603273532115,406.64221877194757,-463.98603273532115L388.9167694769856,-453.55932998347515L375.3620324923756,-458.77266185338976L359.7219588585981,-460.8580102061623L354.5085996802717,-476.4981228519568L343.03919154242584,-471.28475197002524L331.569795108185,-462.9433585589349L324.2710953794894,-456.68735251263405L305.502999216553,-454.6019651478445L297.1616214102694,-467.1140552644801L289.86291387917043,-455.6446393242309L284.649554700844,-455.6446393242309L272.1374879914186,-451.4739816307026L263.79611018513503,-459.81533602977606L253.36938012487715,-453.55932998347515L234.60128396194074,-454.6019651478445L225.21722807806913,-460.8580102061623L200.19309075801664,-460.8580102061623L184.55300542063404,-477.54079702834304L176.21162761435045,-468.1567294408664L149.10213413912197,-484.8394772510302L118.86464973446833,-512.9916410014433L96.96853455345455,-526.5463662824482L83.41379249728234,-542.1864789282426L69.85905239171097,-535.930433869925L64.64569360350475,-534.8877596935387L58.389652446388666,-541.1438047518564L47.962930188534166,-559.9119009147928L46.92025991334957,-579.7226712541155L36.49353765549506,-575.5519745485703L33.36552292873956,-597.4480932406657L22.938796769683368,-587.0213904888195L10.426730060257967,-599.5334415934382L19.810782042927865,-607.8748350045286L0.000003901201776323478,-614.1308410508294"
                }
            ],
            data: [{
                    "id": "id0",
                    "y": 0,
                    value: 30
                },
                {
                    //dagoreti south
                    "id": "id1",
                    "y": 1,
                    value: 6,
                    name: "Point2",
                },
                {
                    //kibra
                    "id": "id2",
                    "y": 2,
                    value: 252389
                },
                {
                    //dagoreti north
                    "id": "id3",
                    "y": 3,
                    value: 256488
                },
                {
                    //starehe
                    "id": "id4",
                    "y": 4,
                    value: 924656
                },
                {
                    //westlands
                    "id": "id5",
                    "y": 5,
                    value: 333
                },
                {
                    //embakasi south
                    "id": "id6",
                    "y": 6,
                    value: 3216
                },
                {
                    //makadara
                    "id": "id7",
                    "y": 7,
                    value: 23215
                },
                {
                    //embakasi west
                    "id": "id8",
                    "y": 8,
                    value: 1564962
                },
                {
                    //embakasi central
                    "id": "id9",
                    "y": 9,
                    value: 3165

                },
                {
                    //kamkunji
                    "id": "id10",
                    "y": 10,
                    value: 6216532
                },
                {
                    //embakasi north
                    "id": "id11",
                    "y": 11,
                    value: 56523
                },
                {
                    //embakasi east
                    "id": "id12",
                    "y": 12,
                    value: 132132
                },
                {
                    //kasarani
                    "id": "id13",
                    "y": 13,
                    value: 65413
                },
                {
                    //ruaraka 
                    "id": "id14",
                    "y": 14,
                    value: 656132
                },
                {
                    //mathare
                    "id": "id15",
                    "y": 15,
                    value: 321165
                },
                {
                    //roysambu
                    "id": "id16",
                    "y": 16,
                    value: 1632
                },
                {
                    //unmatched      
                    "id": "id18",
                    "y": 18,
                    value: 11365895
                },
                {
                    //langata
                    "id": "id19",
                    "y": 19,
                    value: 3
                }
            ]
        }],

        chart: {
            type: 'column',
            backgroundColor: 'transparent'
        },
        lang: {
            thousandsSep: ','
        },
        title: {
            text: 'Collections By sub County',
            style: {
                color: '#a5a8ad',
				align: 'left'
            }
        },
        mapNavigation: {
            enabled: true,


        },
        colorAxis: {
            fill: 'red',
            min: 1,
            backgroundColor: 'red',
            type: 'logarithmic',
            minColor: '#3b3b3b',
            maxColor: '#45d21a',
            /* stops: [
                [0, '#3b3b3b'],
                [0.46, '#40802c'],
                [1, '#45d21a']
            ] */
        },
        legend: {
            layout: 'vertical',
            align: 'left',
            verticalAlign: 'bottom',
            floating: true,
            backgroundColor: 'transparent',
            shadow: false

        },


        tooltip: {
            headerFormat: '<span style="font-size:16px; font-weight:800;">{series.name}</span><br>',
            pointFormat: '<span  style="font-size:16px; font-weight:800; color:{point.color}; text-transform:ucapitalize;">{point.name}</span>: <b style="color:{point.color}">KES {point.value}</b><br/>',


        },

        /* navigation: {
          buttonOptions: {
            theme: {
              'stroke-width': 1,
              stroke: 'white',
              r: 0,
              states: {
                hover: {
                  fill: '#bada55'
                },
                select: {
                  stroke: '#039',
                  fill: '#bbadab'
                }
              }
            }
          }
        } */


    });

});

//setting todays date
var the_date =moment().format("MMMM Do YYYY");
	$('.map-date').text(the_date);

// button functions

// the financial year's data
$('#financial-year').click(function () {
	//getting financial year
	var this_year=moment().format("YYYY");
	var last_year=moment().subtract(1, 'year').format("YYYY");
	var next_year=moment().add(1, 'years').format("YYYY");
	var this_month=moment().format("MM");
	var this_month=parseInt(this_month);
	var fy=last_year+"/"+this_year;
	if(this_month>6){
		fy=this_year+"/"+next_year;
	}
	
	$('.map-date').text(fy+" Financial Year");
	 //changing color axis colors
	$(this).addClass("active").siblings().removeClass("active");
    $('#the-map-container').highcharts()
        .colorAxis[0].update({
            min: 1,

            minColor: '#3b3b3b',
            maxColor: '#2e71ff'
        });
    var chart2 = $('#the-map-container').highcharts();
    //the data 
    chart2.series[0].update([{
            "id": "id0",
            "y": 0,
            value: 330
        },
        {
            //dagoreti south
            "id": "id1",
            "y": 1,
            value: 36,

        },
        {
            //kibra
            "id": "id2",
            "y": 2,
            value: 3252389
        },
        {
            //dagoreti north
            "id": "id3",
            "y": 3,
            value: 3256488
        },
        {
            //starehe
            "id": "id4",
            "y": 4,
            value: 3924656
        },
        {
            //westlands
            "id": "id5",
            "y": 5,
            value: 3333
        },
        {
            //embakasi south
            "id": "id6",
            "y": 6,
            value: 33216
        },
        {
            //makadara
            "id": "id7",
            "y": 7,
            value: 323215
        },
        {
            //embakasi west
            "id": "id8",
            "y": 8,
            value: 31564962
        },
        {
            //embakasi central
            "id": "id9",
            "y": 9,
            value: 33165

        },
        {
            //kamkunji
            "id": "id10",
            "y": 10,
            value: 36216532
        },
        {
            //embakasi north
            "id": "id11",
            "y": 11,
            value: 356523
        },
        {
            //embakasi east
            "id": "id12",
            "y": 12,
            value: 3132132
        },
        {
            //kasarani
            "id": "id13",
            "y": 13,
            value: 365413
        },
        {
            //ruaraka 
            "id": "id14",
            "y": 14,
            value: 656132
        },
        {
            //mathare
            "id": "id15",
            "y": 15,
            value: 321165
        },
        {
            //roysambu
            "id": "id16",
            "y": 16,
            value: 30000000
        },
        {
            //unmatched      
            "id": "id18",
            "y": 18,
            value: 300000
        },
        {
            //langata
            "id": "id19",
            "y": 19,
            value: 332568962
        }
    ]);
    $(this).attr('disabled', true).siblings().attr('disabled', false);
    $('#this-month').attr('disabled', false);
    $('#today').attr('disabled', false);
});

//monthly data for this month
$('#this-month').click(function () {
	
	//geting the date
	var the_date =moment().format("MMMM YYYY");
	$('.map-date').text(the_date);
	
    //changing color
	$(this).addClass("active").siblings().removeClass("active");
    $('#the-map-container').highcharts()
        .colorAxis[0].update({
            min: 1,

            minColor: '#3b3b3b',
            maxColor: '#fdc502'
        });

    var chart2 = $('#the-map-container').highcharts();
    chart2.series[0].update([{
            "id": "id0",
            "y": 0,
            value: 230
        },
        {
            //dagoreti south
            "id": "id1",
            "y": 1,
            value: 26,
            name: "Point2",
        },
        {
            //kibra
            "id": "id2",
            "y": 2,
            value: 2252389
        },
        {
            //dagoreti north
            "id": "id3",
            "y": 3,
            value: 2256488
        },
        {
            //starehe
            "id": "id4",
            "y": 4,
            value: 2924656
        },
        {
            //westlands
            "id": "id5",
            "y": 5,
            value: 2333
        },
        {
            //embakasi south
            "id": "id6",
            "y": 6,
            value: 23216
        },
        {
            //makadara
            "id": "id7",
            "y": 7,
            value: 223215
        },
        {
            //embakasi west
            "id": "id8",
            "y": 8,
            value: 21564962
        },
        {
            //embakasi central
            "id": "id9",
            "y": 29,
            value: 23165

        },
        {
            //kamkunji
            "id": "id10",
            "y": 10,
            value: 26216532
        },
        {
            //embakasi north
            "id": "id11",
            "y": 11,
            value: 256523
        },
        {
            //embakasi east
            "id": "id12",
            "y": 12,
            value: 2132132
        },
        {
            //kasarani
            "id": "id13",
            "y": 13,
            value: 265413
        },
        {
            //ruaraka 
            "id": "id14",
            "y": 14,
            value: 2656132
        },
        {
            //mathare
            "id": "id15",
            "y": 15,
            value: 2321165
        },
        {
            //roysambu
            "id": "id16",
            "y": 16,
            value: 21632
        },
        {
            //unmatched      
            "id": "id18",
            "y": 18,
            value: 211365895
        },
        {
            //langata
            "id": "id19",
            "y": 19,
            value: 23
        }
    ]);
     $(this).attr('disabled', true).siblings().attr('disabled', false);
    $('#financial-year').attr('disabled', false);
    $('#today').attr('disabled', false);
});

//daily data for today
$('#today').click(function () {
	//geting the date
	var the_date =moment().format("MMMM Do YYYY");
	$('.map-date').text(the_date);
//	alert(the_date);
    //color change
	$(this).addClass("active").siblings().removeClass("active");
    $('#the-map-container').highcharts()
        .colorAxis[0].update({
            min: 1,

            minColor: '#3b3b3b',
            maxColor: '#45d21a'
        });
    var chart2 = $('#the-map-container').highcharts();
    chart2.series[0].update([{
                "id": "id0",
                "y": 0,
                value: 30
            },
            {
                //dagoreti south
                "id": "id1",
                "y": 1,
                value: 6,
                name: "Point2",
            },
            {
                //kibra
                "id": "id2",
                "y": 2,
                value: 252389
            },
            {
                //dagoreti north
                "id": "id3",
                "y": 3,
                value: 256488
            },
            {
                //starehe
                "id": "id4",
                "y": 4,
                value: 924656
            },
            {
                //westlands
                "id": "id5",
                "y": 5,
                value: 333
            },
            {
                //embakasi south
                "id": "id6",
                "y": 6,
                value: 3216
            },
            {
                //makadara
                "id": "id7",
                "y": 7,
                value: 23215
            },
            {
                //embakasi west
                "id": "id8",
                "y": 8,
                value: 1564962
            },
            {
                //embakasi central
                "id": "id9",
                "y": 9,
                value: 3165

            },
            {
                //kamkunji
                "id": "id10",
                "y": 10,
                value: 6216532
            },
            {
                //embakasi north
                "id": "id11",
                "y": 11,
                value: 56523
            },
            {
                //embakasi east
                "id": "id12",
                "y": 12,
                value: 132132
            },
            {
                //kasarani
                "id": "id13",
                "y": 13,
                value: 65413
            },
            {
                //ruaraka 
                "id": "id14",
                "y": 14,
                value: 656132
            },
            {
                //mathare
                "id": "id15",
                "y": 15,
                value: 321165
            },
            {
                //roysambu
                "id": "id16",
                "y": 16,
                value: 1632
            },
            {
                //unmatched      
                "id": "id18",
                "y": 18,
                value: 11365895
            },
            {
                //langata
                "id": "id19",
                "y": 19,
                value: 3
            }
        ]

    );
     $(this).attr('disabled', true).siblings().attr('disabled', false);
    $('#financial-year').attr('disabled', false);
    $('#this-month').attr('disabled', false);
});

//this week
    $('#this-week').click(function() {
		//getting this weeks dates
		const today = moment();
		const otherday=moment()
		const too_date = otherday.endOf('week');	
		const from_date = today.startOf('week');			
		const the_date=from_date.format("MMMM Do YYYY")+' To '+too_date.format("MMMM Do YYYY");
		$('.map-date').text(the_date);
		
		
    //color change
		$(this).addClass("active").siblings().removeClass("active");
    $('#the-map-container').highcharts()
            .colorAxis[0].update({
				min: 1,
				
				minColor: '#3b3b3b',
				maxColor: '#ea00d9'
			});
    		 var chart2 = $('#the-map-container').highcharts();
        chart2.series[0].update( [
      {
        "id": "id0",
        "y": 0,
        value: 30
      },
      {
        //dagoreti south
        "id": "id1",
        "y": 1,
        value: 6,
        name: "Point2",
      },
      {
      	//kibra
        "id": "id2",
        "y": 2,
        value: 2572389
      },
      {
      	//dagoreti north
        "id": "id3",
        "y": 3,
        value:2576488
      },
      {
      //starehe
        "id": "id4",
        "y": 4,
        value: 9274656
      },
      {
      	//westlands
        "id": "id5",
        "y": 5,
        value:3337776
      },
      {
      	//embakasi south
        "id": "id6",
        "y": 6,
        value:673216
      },
      {
      	//makadara
        "id": "id7",
        "y": 7,
        value: 2328715
      },
      {
      	//embakasi west
        "id": "id8",
        "y": 8,
        value:15564962
      },
      {
      	//embakasi central
        "id": "id9",
        "y": 9,
        value:3166785
        
      },
      {
      	//kamkunji
        "id": "id10",
        "y": 10,
        value:6216789532
      },
      {
      	//embakasi north
        "id": "id11",
        "y": 11,
        value:565423
      },
      {
      	//embakasi east
        "id": "id12",
        "y": 12,
        value:1325132
      },
      {
      	//kasarani
        "id": "id13",
        "y": 13,
        value:657413
      },
      {
      	//ruaraka 
        "id": "id14",
        "y": 14,
        value:6567132
      },
      {
      	//mathare
        "id": "id15",
        "y": 15,
        value:3271165
      },
      {
      	//roysambu
        "id": "id16",
        "y": 16,
        value:1789632
      },      
      {
      //unmatched      
        "id": "id18",
        "y": 18,
        value:11365895
      },
      {
      	//langata
        "id": "id19",
        "y": 19,
        value:78903
      }
    ]
        
        );
        $(this).attr('disabled', true).siblings().attr('disabled', false);
        $('#financial-year').attr('disabled', false);
         $('#this-month').attr('disabled', false);
    });
